#ifndef __BOOT_WRITER_H
#define __BOOT_WRITER_H

#define BOOT_WRITER 						1

#define SERIAL_BOOTLOADER_VERSION			1.00

#define BW_LED_ON_TIMEOUT					400
#define BW_LED_OFF_TIMEOUT					18000

#define BW_TIMEOUT_LONG						24
#define BW_TIMEOUT_SHORT					2

/* The following should be different to all commands */
#define MAGIC_BYTE_COMMAND_ECHO				0x76

#define CMD_BW_SET_FLASH_ADDRESS			0xC0
#define CMD_BW_SET_END_ADDRESS				0xC1
#define CMD_BW_READ_MEMORY					0xC2
#define CMD_BW_WRITE_MEMORY					0xC3
#define CMD_BW_ERASE_MEMORY					0xC4
#define CMD_BW_BOOT_RESET					0xC5
#define CMD_BW_RESYNC						0xC6
#define CMD_BW_GET_DONE						0xC7	
#define CMD_BW_WRITE_WORD					0xC8

#define INCREMENTAL_SERIAL					0

void 			idleTaskSerialBootloader(void);
unsigned char 	getSerialCharsBootloader(unsigned char* in, unsigned int num, unsigned char reply, unsigned char echo);
unsigned char 	putSerialCharsBootloader(unsigned char* in, unsigned int num);
unsigned long 	EraseFlashOverSerial(unsigned long startaddr, unsigned long endaddr);
unsigned long 	ReadFlashOverSerial(unsigned long startaddr, unsigned long endaddr);
unsigned char 	doBootLoaderUpdate(void);
void 			WriteFlashSerial(unsigned long startaddr, unsigned int num_bytes, unsigned char *flash_array);
void 			WriteWordFlashSerial(unsigned long startaddr, unsigned int data);


#endif
